/**********************************************************
*
*	FILE				: motor_drv.h
* 					     
*
*	PURPOSE			: Motor Controller header file based on 
*						  MC10B8CV1 Motor Controller Block
*						  Description
**********************************************************/

#ifndef _MOTOR_DRV_H_
#define _MOTOR_DRV_H_

#define	CW					0
#define	CCW				1

#define	DIV1				0x00
#define	DIV2				0x01
#define	DIV4				0x02
#define	DIV8				0x03

#define	FULLBRIDGE		0x02
#define	DUALFULLBRIDGE 0x03

#define	CHANNEL_DIS		0x00
#define	LEFTALIGN		0x01
#define	RIGHTALIGN		0x02
#define	CENTERALIGN		0x03

#define	CHANDELAY0		0x00
#define	CHANDELAY1		0x01
#define	CHANDELAY2		0x02
#define	CHANDELAY3		0x03

#define	MC_PERIOD		0x07FF
#define 	MC_PER_OFF		0x0000;	

#define	MAX_STEP_CNT	0x0140	// max 320 steps


extern word steps_to_move;
extern word num_steps;
extern word cur_ptr_pos;			// current pointer position var
extern word new_ptr_pos;


/************* Function Prototypes ***********************/
void MC_init(void);					// initialize Motor Controller
void MC_zero_pointer(void);		// move pointer to "0" position


void MC_step_dir(byte dir);	// setup MC to move pointer in "dir"
void MC_step(word step);			// step motor CCW for # of steps indicated


#endif	// _MOTOR_DRV_H_